#include <algorithm>
#include <cmath>
#include <iostream>
#include <iterator>
#include <utility>
#include <vector>
using namespace std;

double kros(pair<double, double> &o, pair<double, double> &a,
            pair<double, double> &b) {
  return (a.first - o.first) * (b.second - o.second) -
         (a.second - o.second) * (b.first - o.first);
}

vector<pair<double, double>>
andrejev_algoritam(vector<pair<double, double>> tacke) {
  double n = tacke.size(), k = 0;
  vector<pair<double, double>> omotac(2 * n);

  for (int i = 0; i < n; i++) {
    while (k >= 2 && kros(omotac[k - 2], omotac[k - 1], tacke[i]) < 0)
      k--;
    omotac[k++] = tacke[i];
  }

  for (int i = n - 1, t = k + 1; i > 0; i--) {
    while (k >= t && kros(omotac[k - 2], omotac[k - 1], tacke[i - 1]) < 0)
      k--;
    omotac[k++] = tacke[i - 1];
  }

  omotac.resize(k - 1);
  return omotac;
}

double povrsina_poligona(vector<pair<double, double>> poligon) {
  double povrsina = 0.0;

  for (int i = 0; i < poligon.size(); ++i) {
    int j = (i + 1) % poligon.size();
    povrsina += 0.5 * (poligon[i].first * poligon[j].second -
                       poligon[j].first * poligon[i].second);
  }

  return povrsina;
}

bool uso_il_izaso(pair<double, double> tacka,
                  vector<pair<double, double>> &poligon) {
  int presek = 0;

  for (int i = 0; i < poligon.size(); i++) {
    double x1 = poligon[i].first;
    double y1 = poligon[i].second;
    double x2 = poligon[(i + 1) % poligon.size()].first;
    double y2 = poligon[(i + 1) % poligon.size()].second;

    if ((y1 > tacka.second) != (y2 > tacka.second) &&
        tacka.first < (x2 - x1) * (tacka.second - y1) / (y2 - y1) + x1) {
      presek++;
    }
  }

  return presek % 2 != 0;
}

double heronova_formula(pair<double, double> &p1, pair<double, double> &p2,
                        pair<double, double> &p3) {
  double a = sqrt(pow(p2.first - p1.first, 2) + pow(p2.second - p1.second, 2));
  double b = sqrt(pow(p3.first - p2.first, 2) + pow(p3.second - p2.second, 2));
  double c = sqrt(pow(p1.first - p3.first, 2) + pow(p1.second - p3.second, 2));

  double s = (a + b + c) / 2.0;

  double povrsina = sqrt(s * (s - a) * (s - b) * (s - c));

  return povrsina;
}

int main() {
  int n;
  cin >> n;

  vector<pair<double, double>> tacke(n);
  for (int i = 0; i < n; i++) {
    cin >> tacke[i].first >> tacke[i].second;
  }

  sort(tacke.begin(), tacke.end());
  vector<pair<double, double>> ceo_omotac = andrejev_algoritam(tacke);
  vector<pair<double, double>> kopija = ceo_omotac;
  double povrsina = povrsina_poligona(ceo_omotac);
  sort(kopija.begin(), kopija.end());
  set_symmetric_difference(tacke.begin(), tacke.end(), kopija.begin(),
                           kopija.end(), back_inserter(kopija));

  pair<double, double> crna_ovca = kopija.back();
  kopija.pop_back();

  int danger_triangle = 1;
  vector<double> povrsine;
  vector<pair<double, double>> prozor = {ceo_omotac.back(), ceo_omotac.front(),
                                         ceo_omotac[1]};
  for (int i = 1; i <= ceo_omotac.size(); i++) {
    if (uso_il_izaso(crna_ovca, prozor)) {
      danger_triangle = i - 1;
    }
    povrsine.push_back(heronova_formula(prozor[0], prozor[1], prozor[2]));
    prozor[0] = prozor[1];
    prozor[1] = prozor[2];
    prozor[2] = ceo_omotac[(i + 1) % ceo_omotac.size()];
  }

  double max_povrsina = 0.0;
  for (int i = 0; i < ceo_omotac.size(); i++) {
    if (i == danger_triangle) {
      continue;
    }
    if (povrsine[i] > max_povrsina) {
      max_povrsina = povrsine[i];
    }
  }

  cout << round(povrsina - max_povrsina) << endl;
  return 0;
}